/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.items;

import io.github.davidqf555.minecraft.beams.common.items.WhitelistTargetingModuleItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class EntityTypeTargetingModuleItem
extends WhitelistTargetingModuleItem {
    private static final Component INSTRUCTIONS = Component.m_237115_((String)"item.beams.entity_type_targeting_module.instructions").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_PURPLE);
    private static final String TYPE_NAME = "item.beams.entity_type_targeting_module.type_name";

    public EntityTypeTargetingModuleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean shouldTargetWhitelist(ItemStack stack, Entity entity) {
        return this.getMarkedTypes(stack).contains(entity.m_6095_());
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!entity.m_9236_().m_5776_()) {
            boolean success = player.m_6144_() ? this.removeMarkedType(stack, entity.m_6095_()) : this.addMarkedType(stack, entity.m_6095_());
            return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return super.m_6880_(stack, player, entity, hand);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        super.m_7373_(stack, world, text, flag);
        for (EntityType<?> type : this.getMarkedTypes(stack)) {
            text.add((Component)Component.m_237110_((String)TYPE_NAME, (Object[])new Object[]{type.m_20676_()}).m_130940_(ChatFormatting.BLUE));
        }
        text.add(INSTRUCTIONS);
    }

    public Set<EntityType<?>> getMarkedTypes(ItemStack stack) {
        HashSet types = new HashSet();
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Types", 9)) {
            tag.m_128437_("Types", 8).stream().map(Tag::m_7916_).map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(arg_0)).forEach(types::add);
        }
        return types;
    }

    public boolean addMarkedType(ItemStack stack, EntityType<?> type) {
        ListTag list;
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Types", 9)) {
            list = tag.m_128437_("Types", 8);
            if (list.stream().map(Tag::m_7916_).anyMatch(ForgeRegistries.ENTITY_TYPES.getKey(type).toString()::equals)) {
                return false;
            }
        } else {
            list = new ListTag();
            tag.m_128365_("Types", (Tag)list);
        }
        list.add((Object)StringTag.m_129297_((String)ForgeRegistries.ENTITY_TYPES.getKey(type).toString()));
        return true;
    }

    public boolean removeMarkedType(ItemStack stack, EntityType<?> type) {
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Types", 9)) {
            ListTag list = tag.m_128437_("Types", 8);
            return list.removeIf(nbt -> nbt.m_7916_().equals(ForgeRegistries.ENTITY_TYPES.getKey((Object)type).toString()));
        }
        return false;
    }
}

