/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.items;

import io.github.davidqf555.minecraft.beams.common.items.TargetingModuleItem;
import io.github.davidqf555.minecraft.beams.common.modules.targeting.EntityTargetingType;
import io.github.davidqf555.minecraft.beams.common.modules.targeting.TargetingModuleType;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public abstract class WhitelistTargetingModuleItem
extends TargetingModuleItem {
    private static final Component BLACKLIST = Component.m_237115_((String)"item.beams.whitelist_targeting_module.blacklist").m_130940_(ChatFormatting.GREEN);
    private static final Component WHITELIST = Component.m_237115_((String)"item.beams.whitelist_targeting_module.whitelist").m_130940_(ChatFormatting.RED);

    public WhitelistTargetingModuleItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract boolean shouldTargetWhitelist(ItemStack var1, Entity var2);

    @Override
    public TargetingModuleType getType(ItemStack stack) {
        Predicate<Entity> condition = entity -> this.shouldTargetWhitelist(stack, (Entity)entity);
        if (!this.isWhitelist(stack)) {
            condition = condition.negate();
        }
        return new EntityTargetingType(condition);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> text, TooltipFlag flag) {
        super.m_7373_(stack, world, text, flag);
        text.add(this.isWhitelist(stack) ? WHITELIST : BLACKLIST);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.m_5776_()) {
            ItemStack stack;
            this.setWhitelist(stack, !this.isWhitelist(stack = player.m_21120_(hand)));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public void setWhitelist(ItemStack stack, boolean whitelist) {
        stack.m_41698_("beams").m_128379_("Whitelist", whitelist);
    }

    public boolean isWhitelist(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("beams");
        if (tag.m_128425_("Whitelist", 1)) {
            return tag.m_128471_("Whitelist");
        }
        return false;
    }
}

