/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.registration;

import com.mojang.datafixers.util.Pair;
import io.github.davidqf555.minecraft.beams.common.items.EntityTypeTargetingModuleItem;
import io.github.davidqf555.minecraft.beams.common.items.PlayerTargetingModuleItem;
import io.github.davidqf555.minecraft.beams.common.items.PointerItem;
import io.github.davidqf555.minecraft.beams.common.items.PortableProjectorItem;
import io.github.davidqf555.minecraft.beams.common.items.ProjectorModuleItem;
import io.github.davidqf555.minecraft.beams.common.modules.ColorModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.DamageModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.EnderModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.FireModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.ForceModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.FreezeModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.LayersModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.MiningModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.PotionEffectModuleType;
import io.github.davidqf555.minecraft.beams.common.modules.SizeModuleType;
import io.github.davidqf555.minecraft.beams.registration.BlockRegistry;
import io.github.davidqf555.minecraft.beams.registration.ProjectorModuleRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="beams", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"beams");
    private static final List<Pair<ResourceKey<CreativeModeTab>, Supplier<? extends Item>>> TABS = new ArrayList<Pair<ResourceKey<CreativeModeTab>, Supplier<? extends Item>>>();
    private static final ResourceKey<CreativeModeTab> TAB = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("beams", "main"));
    public static final RegistryObject<BlockItem> PROJECTOR = ItemRegistry.register("projector", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.PROJECTOR.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> TILTED_PROJECTOR = ItemRegistry.register("tilted_projector", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.TILTED_PROJECTOR.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> OMNIDIRECTIONAL_PROJECTOR = ItemRegistry.register("omnidirectional_projector", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.OMNIDIRECTIONAL_PROJECTOR.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> MIRROR = ItemRegistry.register("mirror", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.MIRROR.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> PHOTODETECTOR = ItemRegistry.register("photodetector", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.PHOTODETECTOR.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> OMNIDIRECTIONAL_MIRROR = ItemRegistry.register("omnidirectional_mirror", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.OMNIDIRECTIONAL_MIRROR.get(), new Item.Properties()));
    public static final RegistryObject<BlockItem> TURRET = ItemRegistry.register("turret", ItemRegistry.getTab(), () -> new BlockItem((Block)BlockRegistry.TURRET.get(), new Item.Properties()));
    public static final RegistryObject<PortableProjectorItem> PORTABLE_PROJECTOR = ItemRegistry.register("portable_projector", ItemRegistry.getTab(), () -> new PortableProjectorItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<PointerItem> POINTER = ItemRegistry.register("projector_pointer", ItemRegistry.getTab(), () -> new PointerItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> BLANK_MODULE = ItemRegistry.register("blank_module", ItemRegistry.getTab(), () -> new Item(new Item.Properties()));
    public static final Map<DyeColor, RegistryObject<ProjectorModuleItem<ColorModuleType>>> COLOR_MODULES = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(color -> color, color -> ItemRegistry.register(color.m_7912_() + "_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem((Supplier)ProjectorModuleRegistry.COLORS.get(color), new Item.Properties()))));
    public static final RegistryObject<ProjectorModuleItem<PotionEffectModuleType>> BRIGHT_MODULE = ItemRegistry.register("bright_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<PotionEffectModuleType>((Supplier<PotionEffectModuleType>)ProjectorModuleRegistry.BRIGHT, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<FireModuleType>> HOT_MODULE = ItemRegistry.register("hot_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<FireModuleType>((Supplier<FireModuleType>)ProjectorModuleRegistry.HOT, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<DamageModuleType>> DAMAGE_MODULE = ItemRegistry.register("damage_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<DamageModuleType>((Supplier<DamageModuleType>)ProjectorModuleRegistry.DAMAGE, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<EnderModuleType>> ENDER_MODULE = ItemRegistry.register("ender_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<EnderModuleType>((Supplier<EnderModuleType>)ProjectorModuleRegistry.ENDER, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<ForceModuleType>> FORCE_MODULE = ItemRegistry.register("force_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<ForceModuleType>((Supplier<ForceModuleType>)ProjectorModuleRegistry.FORCE, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<MiningModuleType>> MINING_MODULE = ItemRegistry.register("mining_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<MiningModuleType>((Supplier<MiningModuleType>)ProjectorModuleRegistry.MINING, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<LayersModuleType>> LAYERS_MODULE = ItemRegistry.register("layers_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<LayersModuleType>((Supplier<LayersModuleType>)ProjectorModuleRegistry.LAYERS, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<SizeModuleType>> GROWTH_MODULE = ItemRegistry.register("growth_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<SizeModuleType>((Supplier<SizeModuleType>)ProjectorModuleRegistry.GROWTH, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<SizeModuleType>> SHRINK_MODULE = ItemRegistry.register("shrink_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<SizeModuleType>((Supplier<SizeModuleType>)ProjectorModuleRegistry.SHRINK, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<ForceModuleType>> TRACTOR_MODULE = ItemRegistry.register("tractor_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<ForceModuleType>((Supplier<ForceModuleType>)ProjectorModuleRegistry.TRACTOR, new Item.Properties()));
    public static final RegistryObject<ProjectorModuleItem<FreezeModuleType>> FREEZE_MODULE = ItemRegistry.register("freeze_module", ItemRegistry.getTab(), () -> new ProjectorModuleItem<FreezeModuleType>((Supplier<FreezeModuleType>)ProjectorModuleRegistry.FREEZE, new Item.Properties()));
    public static final RegistryObject<PlayerTargetingModuleItem> PLAYER_TARGETING_MODULE = ItemRegistry.register("player_targeting_module", ItemRegistry.getTab(), () -> new PlayerTargetingModuleItem(new Item.Properties()));
    public static final RegistryObject<EntityTypeTargetingModuleItem> ENTITY_TYPE_TARGETING_MODULE = ItemRegistry.register("entity_type_targeting_module", ItemRegistry.getTab(), () -> new EntityTypeTargetingModuleItem(new Item.Properties()));

    private ItemRegistry() {
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)TAB.m_135782_(), (Object)CreativeModeTab.builder().m_257737_(() -> ((BlockItem)PROJECTOR.get()).m_7968_()).m_257941_((Component)Component.m_237115_((String)Util.m_137492_((String)"itemGroup", (ResourceLocation)TAB.m_135782_()))).m_257652_()));
    }

    @SubscribeEvent
    public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        TABS.stream().filter(pair -> event.getTabKey().equals(pair.getFirst())).map(Pair::getSecond).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
    }

    public static ResourceKey<CreativeModeTab> getTab() {
        return TAB;
    }

    private static <T extends Item> RegistryObject<T> register(String name, ResourceKey<CreativeModeTab> tab, Supplier<T> item) {
        RegistryObject out = ITEMS.register(name, item);
        if (tab != null) {
            TABS.add((Pair<ResourceKey<CreativeModeTab>, Supplier<? extends Item>>)Pair.of(tab, (Object)out));
        }
        return out;
    }
}

