/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.altar;

import elucent.rootsclassic.block.brazier.BrazierBlockEntity;
import elucent.rootsclassic.blockentity.BEBase;
import elucent.rootsclassic.client.particles.MagicAltarParticleData;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.recipe.RitualRecipe;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.ritual.RitualPillars;
import elucent.rootsclassic.ritual.RitualRegistry;
import elucent.rootsclassic.util.InventoryUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class AltarBlockEntity
extends BEBase {
    private static final int RECIPE_PROGRESS_TIME = 200;
    private List<ItemStack> incenses = new ArrayList<ItemStack>();
    private int ticker = 0;
    private int progress = 0;
    @Nullable
    private RitualRecipe<?> ritualCurrent = null;
    private int clientRitualLevel;
    private Color clientRitualColor;
    private Color clientRitualSecondaryColor;
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public AltarBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public AltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RootsRegistry.ALTAR_TILE.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("InventoryHandler"));
        this.setIncenses(new ArrayList<ItemStack>());
        if (tag.m_128441_("incenses")) {
            ListTag list = tag.m_128437_("incenses", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.getIncenses().add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
            }
        }
        if (tag.m_128441_("progress")) {
            this.setProgress(tag.m_128451_("progress"));
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && tag.m_128425_("ritual", 10)) {
            CompoundTag ritualTag = tag.m_128469_("ritual");
            this.clientRitualLevel = ritualTag.m_128451_("level");
            this.clientRitualColor = new Color(ritualTag.m_128451_("color"));
            this.clientRitualSecondaryColor = new Color(ritualTag.m_128451_("secondaryColor"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InventoryHandler", (Tag)this.inventory.serializeNBT());
        if (this.getIncenses().size() > 0) {
            ListTag list = new ListTag();
            for (int i = 0; i < this.getIncenses().size(); ++i) {
                list.add((Object)this.getIncenses().get(i).m_41739_(new CompoundTag()));
            }
            tag.m_128365_("incenses", (Tag)list);
        }
        tag.m_128405_("progress", this.getProgress());
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.ritualCurrent != null) {
            CompoundTag ritualTag = new CompoundTag();
            ritualTag.m_128405_("level", this.ritualCurrent.level);
            ritualTag.m_128405_("color", this.ritualCurrent.color.getRGB());
            ritualTag.m_128405_("secondaryColor", this.ritualCurrent.secondaryColor.getRGB());
            tag.m_128365_("ritual", (Tag)ritualTag);
        }
    }

    @Override
    public void breakBlock(Level levelAccessor, BlockPos pos, BlockState state, Player player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack;
            if (levelAccessor.f_46443_ || (slotStack = this.inventory.getStackInSlot(i)).m_41619_()) continue;
            levelAccessor.m_7967_((Entity)new ItemEntity(levelAccessor, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, slotStack));
        }
        this.m_7651_();
    }

    @Override
    public InteractionResult activate(Level levelAccessor, BlockPos pos, BlockState state, Player player, InteractionHand hand, ItemStack heldItem, BlockHitResult hit) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (heldItem.m_41619_() && !player.m_6144_() && this.getProgress() == 0) {
                if (this.inventory.getSlots() > 0) {
                    ItemStack lastStack = InventoryUtil.getLastStack((IItemHandler)this.inventory);
                    if (!lastStack.m_41619_()) {
                        if (!levelAccessor.f_46443_) {
                            levelAccessor.m_7967_((Entity)new ItemEntity(levelAccessor, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, lastStack.m_41777_()));
                        }
                        lastStack.m_41774_(1);
                        this.m_6596_();
                        levelAccessor.m_7260_(pos, state, levelAccessor.m_8055_(pos), 3);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (player.m_6144_() && heldItem.m_41619_() && this.getProgress() == 0) {
                    this.setRitualCurrent(null);
                    Optional<RitualRecipe<?>> optionalRitual = RitualRegistry.findMatchingByIngredients(this);
                    if (optionalRitual.isEmpty()) {
                        player.m_5661_((Component)Component.m_237115_((String)"rootsclassic.error.noritual.ingredients"), true);
                        return InteractionResult.FAIL;
                    }
                    RitualRecipe<?> ritual = optionalRitual.get();
                    if (!RitualPillars.verifyPositionBlocks(ritual, levelAccessor, pos)) {
                        player.m_5661_((Component)Component.m_237115_((String)"rootsclassic.error.noritual.stones"), true);
                        return InteractionResult.FAIL;
                    }
                    if (ritual.incenseMatches(this.f_58857_, pos)) {
                        this.setRitualCurrent(ritual);
                        this.setIncenses(RitualRegistry.getIncenses(levelAccessor, pos));
                        this.setProgress(200);
                        for (BrazierBlockEntity brazier : RitualPillars.getRecipeBraziers(levelAccessor, pos)) {
                            brazier.setBurning(true);
                            brazier.setHeldItem(ItemStack.f_41583_);
                        }
                        this.m_6596_();
                        levelAccessor.m_7260_(pos, state, levelAccessor.m_8055_(pos), 3);
                        player.m_5661_((Component)Component.m_237115_((String)"rootsclassic.ritual.started"), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"rootsclassic.error.noritual.incense"), true);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!InventoryUtil.isFull((IItemHandler)this.inventory) && this.getProgress() == 0) {
                    ItemStack copyStack = heldItem.m_41777_();
                    copyStack.m_41764_(1);
                    ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)copyStack, (boolean)false);
                    if (remaining.m_41619_()) {
                        heldItem.m_41774_(1);
                        this.m_6596_();
                        levelAccessor.m_7260_(pos, state, levelAccessor.m_8055_(pos), 3);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AltarBlockEntity tile) {
        tile.setTicker(tile.getTicker() + 3);
        if (tile.getTicker() > 360) {
            tile.setTicker(0);
        }
        if (tile.getProgress() > 0 && tile.getRitualCurrent() != null) {
            tile.setProgress(tile.getProgress() - 1);
            if (tile.getProgress() == 0 && tile.getRitualCurrent() != null) {
                tile.getRitualCurrent().doEffect(level, pos, InventoryUtil.createIInventory((IItemHandler)tile.inventory), tile.getIncenses());
                tile.setRitualCurrent(null);
                tile.emptyAltar();
                tile.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, AltarBlockEntity tile) {
        if (tile.getProgress() > 0 && tile.getRitualCurrent() != null) {
            tile.setProgress(tile.getProgress() - 1);
            Map<BlockPos, Block> pillars = RitualPillars.getRitualPillars(tile.clientRitualLevel);
            List pillarPositions = pillars.keySet().stream().toList();
            Color color = tile.clientRitualColor;
            Color secondaryColor = tile.clientRitualSecondaryColor;
            if (color == null || secondaryColor == null) {
                return;
            }
            if (pillarPositions.size() > 0) {
                BlockPos particlePos = ((BlockPos)pillarPositions.get(level.f_46441_.m_188503_(pillarPositions.size()))).m_7494_().m_7918_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                if (level.f_46441_.m_188503_(6) == 0) {
                    level.m_7106_(MagicLineParticleData.createData(color.getRed(), color.getGreen(), color.getBlue()), (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.125, (double)particlePos.m_123343_() + 0.5, (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.875, (double)particlePos.m_123343_() + 0.5);
                } else {
                    level.m_7106_(MagicLineParticleData.createData(secondaryColor.getRed(), secondaryColor.getGreen(), secondaryColor.getBlue()), (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.125, (double)particlePos.m_123343_() + 0.5, (double)particlePos.m_123341_() + 0.5, (double)particlePos.m_123342_() + 0.875, (double)particlePos.m_123343_() + 0.5);
                }
            }
            if (level.f_46441_.m_188503_(4) == 0) {
                level.m_7106_(MagicAltarParticleData.createData(color.getRed(), color.getGreen(), color.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            } else {
                level.m_7106_(MagicAltarParticleData.createData(secondaryColor.getRed(), secondaryColor.getGreen(), secondaryColor.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            }
            if (level.f_46441_.m_188503_(4) == 0) {
                level.m_7106_(MagicAltarParticleData.createData(color.getRed(), color.getGreen(), color.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(90.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(90.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            } else {
                level.m_7106_(MagicAltarParticleData.createData(secondaryColor.getRed(), secondaryColor.getGreen(), secondaryColor.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(90.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(90.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            }
            if (level.f_46441_.m_188503_(4) == 0) {
                level.m_7106_(MagicAltarParticleData.createData(color.getRed(), color.getGreen(), color.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            } else {
                level.m_7106_(MagicAltarParticleData.createData(secondaryColor.getRed(), secondaryColor.getGreen(), secondaryColor.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            }
            if (level.f_46441_.m_188503_(4) == 0) {
                level.m_7106_(MagicAltarParticleData.createData(color.getRed(), color.getGreen(), color.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(270.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(270.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            } else {
                level.m_7106_(MagicAltarParticleData.createData(secondaryColor.getRed(), secondaryColor.getGreen(), secondaryColor.getBlue()), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, 0.125 * Math.sin(Math.toRadians(270.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(270.0 + 360.0 * (double)(tile.getProgress() % 100) / 100.0)));
            }
        }
    }

    public List<ItemStack> getIncenses() {
        return this.incenses;
    }

    public void setIncenses(List<ItemStack> incenses) {
        this.incenses = incenses;
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Nullable
    public RitualRecipe<?> getRitualCurrent() {
        return this.ritualCurrent;
    }

    public void setRitualCurrent(RitualRecipe<?> ritualCurrent) {
        this.ritualCurrent = ritualCurrent;
        this.m_6596_();
    }

    public void emptyAltar() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

