/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.lothrazar.library.config.ConfigTemplate;
import elucent.rootsclassic.Roots;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class RootsConfig
extends ConfigTemplate {
    private static ForgeConfigSpec CLIENT;
    private static ForgeConfigSpec COMMON;
    public static ForgeConfigSpec.IntValue oldRootDropChance;
    public static ForgeConfigSpec.IntValue verdantSprigDropChance;
    public static ForgeConfigSpec.IntValue infernalStemDropChance;
    public static ForgeConfigSpec.IntValue dragonsEyeDropChance;
    public static ForgeConfigSpec.IntValue berriesDropChance;
    public static ForgeConfigSpec.DoubleValue barkKnifeBlockStripChance;
    public static ForgeConfigSpec.IntValue chargeTicks;
    public static ForgeConfigSpec.IntValue staffUses;
    public static ForgeConfigSpec.IntValue efficiencyBonus;
    public static ForgeConfigSpec.BooleanValue disablePVP;
    public static ForgeConfigSpec.IntValue ticksPerManaRegen;
    public static ForgeConfigSpec.IntValue staffUsesBasic;
    public static ForgeConfigSpec.IntValue staffUsesEfficiency;

    public void setupMain() {
        COMMON.setConfig((CommentedConfig)this.setup("rootsclassic"));
    }

    public void setupClient() {
        CLIENT.setConfig((CommentedConfig)this.setup("rootsclassic-client"));
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT);
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        Roots.LOGGER.debug("Loaded Roots Classic's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public void onFileChange(ModConfigEvent.Reloading configEvent) {
        Roots.LOGGER.warn("Roots Classic's config just got changed on the file system!");
    }

    static {
        ForgeConfigSpec.Builder builder = RootsConfig.builder();
        builder.comment("Settings related to actual gameplay-affecting features").push("items");
        oldRootDropChance = builder.comment("  Old Roots will drop from tall grass with a 1/oldRootDropChance probability").defineInRange("oldRootDropChance", 40, 0, Short.MAX_VALUE);
        verdantSprigDropChance = builder.comment("  Verdant Sprigs will drop from grown crops with a 1/verdantSprigDropChance probability").defineInRange("verdantSprigDropChance", 30, 0, Short.MAX_VALUE);
        infernalStemDropChance = builder.comment("  Infernal Bulbs will drop from nether wart with a 1/infernalBulbDropChance probability").defineInRange("infernalStemDropChance", 20, 0, Short.MAX_VALUE);
        dragonsEyeDropChance = builder.comment("  Dragon's Eyes will drop from chorus flowers with a 1/dragonsEyeDropChance probability").defineInRange("dragonsEyeDropChance", 10, 0, Short.MAX_VALUE);
        berriesDropChance = builder.comment("  Berries will drop from oak leaves with a 1/berriesDropChance probability").defineInRange("berriesDropChance", 25, 0, Short.MAX_VALUE);
        barkKnifeBlockStripChance = builder.comment("  Chance that the bark knife will strip the log, 1 is always strip on first harvest").defineInRange("barkKnifeBlockStripChance", (double)0.3f, (double)0.1f, 1.0);
        builder.pop();
        builder.comment("  Settings related to actual gameplay-affecting features").push("magic");
        chargeTicks = builder.comment("The number of ticks required to prepare a spell with a staff").defineInRange("staffChargeTicks", 20, 1, Short.MAX_VALUE);
        staffUses = builder.comment("  The number of uses an unmodified staff will have upon being crafted").defineInRange("staffUses", 65, 0, Short.MAX_VALUE);
        efficiencyBonus = builder.comment("  The number of additional uses each efficiency modifier gives").defineInRange("efficiencyBonusUses", 32, 0, Short.MAX_VALUE);
        disablePVP = builder.comment("  Whether or not damaging spells can affect players").define("disablePVP", false);
        ticksPerManaRegen = builder.comment("  Number of ticks between each mana regeneration (20 ticks = 1 second)").defineInRange("ticksPerManaRegen", 15, 1, 100);
        staffUsesBasic = builder.comment("  Number of basic uses for one spell staff").defineInRange("staffUsesBasic", 15, 1, 100);
        staffUsesEfficiency = builder.comment("  Number of uses added by each efficiency level on a spell").defineInRange("staffUsesEfficiency", 15, 1, 100);
        builder.pop();
        COMMON = builder.build();
        ForgeConfigSpec.Builder builderClient = RootsConfig.builder();
        builderClient.comment("Client settings").push("client");
        Client.showTabletWave = builderClient.comment("  Toggles the wave effect in the Runic Tablet GUI").define("showTabletWave", true);
        Client.manaBarOffset = builderClient.comment("  The number of pixels above the bottom of the screen that the mana bar should be rendered. If it's conflicting with a bar from another mod, raising it by 10 will normally position it right").defineInRange("manaBarOffset", 49, 0, Short.MAX_VALUE);
        builderClient.pop();
        CLIENT = builderClient.build();
    }

    public static class Client {
        public static ForgeConfigSpec.BooleanValue showTabletWave;
        public static ForgeConfigSpec.IntValue manaBarOffset;
    }
}

