/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.centrifugetiersreproduced.blockentity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.ultramega.centrifugetiersreproduced.CentrifugeTiers;
import com.ultramega.centrifugetiersreproduced.blockentity.InventoryHandlerHelper;
import com.ultramega.centrifugetiersreproduced.container.TieredCentrifugeContainer;
import com.ultramega.centrifugetiersreproduced.recipe.TieredCentrifugeRecipe;
import com.ultramega.centrifugetiersreproduced.registry.IMultiRecipeProcessingBlockEntity;
import com.ultramega.centrifugetiersreproduced.registry.ModBlockEntityTypes;
import com.ultramega.centrifugetiersreproduced.registry.ModBlocks;
import com.ultramega.centrifugetiersreproduced.registry.ModMenuTypes;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.common.item.FilterUpgradeItem;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.GeneBottle;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TieredCentrifugeBlockEntity
extends CapabilityBlockEntity
implements UpgradeableBlockEntity,
IMultiRecipeProcessingBlockEntity {
    private final CentrifugeRecipe[] currentRecipe = new CentrifugeRecipe[4];
    public int[] recipeProgress = new int[4];
    public int fluidId = 0;
    public int transferCooldown = -1;
    public CentrifugeTiers tier;
    private int tankTick = 0;
    private int currentSlot = 0;
    private final LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(21, (BlockEntity)this){

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        @Override
        public boolean isContainerItem(Item item) {
            return false;
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean fromAutomation) {
            ItemStack existing;
            if (fromAutomation && !(existing = (ItemStack)this.stacks.get(slot)).m_41619_() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate, fromAutomation);
        }

        @Override
        public boolean isInputSlotItem(int slot, ItemStack item) {
            ItemStack currentStack = this.getStackInSlot(slot);
            if (currentStack.m_41613_() == currentStack.m_41741_()) {
                return false;
            }
            boolean isProcessableItem = ItemStack.m_150942_((ItemStack)currentStack, (ItemStack)item) || item.m_41720_().equals(ModItems.GENE_BOTTLE.get()) || item.m_41720_().equals(ModItems.HONEY_TREAT.get()) || TieredCentrifugeBlockEntity.this.canProcessItemStack(item);
            return isProcessableItem && (slot == InventoryHandlerHelper.INPUT_SLOT[0] || slot == InventoryHandlerHelper.INPUT_SLOT[1] || slot == InventoryHandlerHelper.INPUT_SLOT[2] || slot == InventoryHandlerHelper.INPUT_SLOT[3]) || !isProcessableItem && !super.isInputSlot(slot);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            for (int i = 0; i < 4; ++i) {
                if (slot != InventoryHandlerHelper.INPUT_SLOT[i] || !this.getStackInSlot(slot).m_41619_()) continue;
                TieredCentrifugeBlockEntity.this.recipeProgress[i] = 0;
            }
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(this.tier.getFluidCapacity()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            TieredCentrifugeBlockEntity.this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)this.getFluid().getFluid());
            TieredCentrifugeBlockEntity.this.m_6596_();
        }
    });
    public LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(this.tier.getEnergyCapacity()));
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(this.tier == CentrifugeTiers.CREATIVE ? 0 : 4, (BlockEntity)this));
    static Map<String, CentrifugeRecipe> blockRecipeMap = new HashMap<String, CentrifugeRecipe>();

    public TieredCentrifugeBlockEntity(BlockEntityType entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        if (entityType == ModBlockEntityTypes.HIGH_END_CENTRIFUGE.get()) {
            this.tier = CentrifugeTiers.HIGH_END;
        } else if (entityType == ModBlockEntityTypes.NUCLEAR_CENTRIFUGE.get()) {
            this.tier = CentrifugeTiers.NUCLEAR;
        } else if (entityType == ModBlockEntityTypes.COSMIC_CENTRIFUGE.get()) {
            this.tier = CentrifugeTiers.COSMIC;
        } else if (entityType == ModBlockEntityTypes.CREATIVE_CENTRIFUGE.get()) {
            this.tier = CentrifugeTiers.CREATIVE;
        }
    }

    @Override
    public TimedRecipeInterface[] getCurrentRecipes() {
        return this.currentRecipe;
    }

    @Override
    public int[] getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(TimedRecipeInterface recipe) {
        return (int)((double)(recipe != null ? recipe.getProcessingTime() : ((Integer)ProductiveBeesConfig.GENERAL.centrifugeProcessingTime.get()).intValue()) * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        return this.getProcessingTimeModifier2() / 3.0 / (double)this.tier.getSpeed();
    }

    protected double getProcessingTimeModifier2() {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier);
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = 1.0 + (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier) * (double)this.tier.getSpeed() * 10.0;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TieredCentrifugeBlockEntity blockEntity) {
        blockEntity.inventoryHandler.ifPresent(invHandler -> {
            blockEntity.currentSlot = blockEntity.currentSlot >= blockEntity.tier.getInputSlotAmount() - 1 ? 0 : ++blockEntity.currentSlot;
            if (!invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[blockEntity.currentSlot]).m_41619_() && blockEntity.canOperate()) {
                ItemStack invItem = invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[blockEntity.currentSlot]);
                if (invItem.m_41720_().equals(ModItems.GENE_BOTTLE.get())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    int totalTime = blockEntity.getProcessingTime(null);
                    int n = blockEntity.currentSlot;
                    blockEntity.recipeProgress[n] = blockEntity.recipeProgress[n] + 1;
                    if (blockEntity.recipeProgress[n] >= totalTime) {
                        blockEntity.completeGeneProcessing((IItemHandlerModifiable)invHandler, level.f_46441_);
                        blockEntity.recipeProgress[blockEntity.currentSlot] = 0;
                        blockEntity.m_6596_();
                    }
                } else if (invItem.m_41720_().equals(ModItems.HONEY_TREAT.get())) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                    int totalTime = blockEntity.getProcessingTime(null);
                    int n = blockEntity.currentSlot;
                    blockEntity.recipeProgress[n] = blockEntity.recipeProgress[n] + 1;
                    if (blockEntity.recipeProgress[n] >= totalTime) {
                        blockEntity.completeTreatProcessing((IItemHandlerModifiable)invHandler);
                        blockEntity.recipeProgress[blockEntity.currentSlot] = 0;
                        blockEntity.m_6596_();
                    }
                } else {
                    CentrifugeRecipe recipe = blockEntity.getRecipe((IItemHandlerModifiable)invHandler);
                    if (blockEntity.canProcessRecipe(recipe, (IItemHandlerModifiable)invHandler)) {
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(true)));
                        int totalTime = blockEntity.getProcessingTime((TimedRecipeInterface)recipe);
                        int n = blockEntity.currentSlot;
                        blockEntity.recipeProgress[n] = blockEntity.recipeProgress[n] + 1;
                        if (blockEntity.recipeProgress[n] >= totalTime) {
                            blockEntity.completeRecipeProcessing(recipe, (IItemHandlerModifiable)invHandler, level.f_46441_);
                            blockEntity.recipeProgress[blockEntity.currentSlot] = 0;
                            blockEntity.m_6596_();
                        }
                    }
                }
            } else {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Centrifuge.RUNNING, (Comparable)Boolean.valueOf(false)));
            }
            if (((Boolean)ProductiveBeesConfig.GENERAL.centrifugeHopperMode.get()).booleanValue() && --blockEntity.transferCooldown <= 0) {
                blockEntity.transferCooldown = 22;
                blockEntity.suckInItems((IItemHandlerModifiable)invHandler);
            }
        });
        if (++blockEntity.tankTick > 21) {
            blockEntity.tankTick = 0;
            blockEntity.tickFluidTank(level, pos, state, blockEntity);
        }
        if (((Boolean)state.m_61143_((Property)Centrifuge.RUNNING)).booleanValue() && level instanceof ServerLevel) {
            blockEntity.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false));
        }
    }

    public void tickFluidTank(Level level, BlockPos pos, BlockState state, TieredCentrifugeBlockEntity blockEntity) {
        this.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
            FluidStack fluidStack = fluidHandler.getFluidInTank(0);
            if (fluidStack.getAmount() > 0) {
                Direction[] directions;
                for (Direction direction : directions = Direction.values()) {
                    BlockEntity te = level.m_7702_(this.f_58858_.m_121945_(direction));
                    if (te == null || fluidStack.getAmount() <= 0) continue;
                    te.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).ifPresent(h -> {
                        int amount = h.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
                        if (amount > 0) {
                            amount = h.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                            fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        }
                    });
                }
            }
        });
    }

    private void suckInItems(IItemHandlerModifiable invHandler) {
        for (ItemEntity itemEntity : this.getCaptureItems()) {
            ItemStack itemStack = itemEntity.m_32055_();
            if (!this.canProcessItemStack(itemStack) && !itemStack.m_41720_().equals(ModItems.GENE_BOTTLE.get()) && (!itemStack.m_41720_().equals(ModItems.HONEY_TREAT.get()) || !HoneyTreat.hasGene((ItemStack)itemStack))) continue;
            TieredCentrifugeBlockEntity.captureItem(invHandler, itemEntity, this.currentSlot);
        }
    }

    private List<ItemEntity> getCaptureItems() {
        assert (this.f_58857_ != null);
        return Centrifuge.COLLECTION_AREA_SHAPE.m_83299_().stream().flatMap(blockPos -> this.f_58857_.m_6443_(ItemEntity.class, blockPos.m_82386_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()), EntitySelector.f_20402_).stream()).collect(Collectors.toList());
    }

    private static void captureItem(IItemHandlerModifiable invHandler, ItemEntity itemEntity, int currentSlot) {
        ItemStack leftoverStack = invHandler.insertItem(InventoryHandlerHelper.INPUT_SLOT[currentSlot], itemEntity.m_32055_(), false);
        if (leftoverStack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(leftoverStack);
        }
    }

    protected boolean canOperate() {
        if (this.tier == CentrifugeTiers.CREATIVE) {
            return true;
        }
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        return energy >= (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    }

    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public boolean canProcessItemStack(ItemStack stack) {
        boolean directProcess = this.canProcessItemStack2(stack);
        if (stack.m_204117_(ModTags.Forge.COMBS) && !directProcess) {
            ItemStack singleComb;
            if (stack.m_41720_() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                singleComb.m_41751_(stack.m_41783_());
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput((Level)this.f_58857_, (Item)stack.m_41720_());
            }
            return !singleComb.m_41619_() && this.canProcessItemStack2(singleComb);
        }
        return directProcess;
    }

    public boolean canProcessItemStack2(ItemStack stack) {
        InventoryHandlerHelper.ItemHandler inv = new InventoryHandlerHelper.ItemHandler(5, null);
        inv.setStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot], stack);
        boolean isAllowedByFilter = true;
        List filterUpgrades = this.getInstalledUpgrades((Item)ModItems.UPGRADE_FILTER.get());
        if (!filterUpgrades.isEmpty()) {
            isAllowedByFilter = false;
            for (ItemStack filter : filterUpgrades) {
                List allowedBees = FilterUpgradeItem.getAllowedBees((ItemStack)filter);
                block1: for (Supplier allowedBee : allowedBees) {
                    List produceList = BeeHelper.getBeeProduce((Level)this.f_58857_, (Bee)((Bee)((BeeIngredient)allowedBee.get()).getCachedEntity(this.f_58857_)), (boolean)false, (double)1.0);
                    for (ItemStack pStack : produceList) {
                        if (!pStack.m_41720_().equals(stack.m_41720_())) continue;
                        isAllowedByFilter = true;
                        continue block1;
                    }
                }
            }
        }
        CentrifugeRecipe recipe = this.getRecipe((IItemHandlerModifiable)inv);
        return isAllowedByFilter && recipe != null;
    }

    protected CentrifugeRecipe getRecipe(IItemHandlerModifiable inputHandler) {
        if (blockRecipeMap.size() > 5000) {
            blockRecipeMap.clear();
        }
        ItemStack input = inputHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]);
        String cacheKey = ForgeRegistries.ITEMS.getKey((Object)input.m_41720_()) + (input.m_41783_() != null ? input.m_41783_().m_7916_() : "");
        CentrifugeRecipe directRecipe = this.getRecipe2(inputHandler);
        if (input.m_204117_(ModTags.Forge.COMBS) && directRecipe == null) {
            if (!blockRecipeMap.containsKey(cacheKey)) {
                ItemStack singleComb;
                if (input.m_41720_() instanceof CombBlockItem) {
                    singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                    singleComb.m_41751_(input.m_41783_());
                } else {
                    singleComb = BeeHelper.getRecipeOutputFromInput((Level)this.f_58857_, (Item)input.m_41720_());
                }
                InventoryHandlerHelper.ItemHandler inv = new InventoryHandlerHelper.ItemHandler(5);
                inv.setStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot], singleComb);
                blockRecipeMap.put(cacheKey, this.getRecipe2((IItemHandlerModifiable)inv));
            }
            return blockRecipeMap.get(cacheKey);
        }
        return directRecipe;
    }

    protected CentrifugeRecipe getRecipe2(IItemHandlerModifiable inputHandler) {
        ItemStack input = inputHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]);
        if (input.m_41619_() || this.f_58857_ == null) {
            return null;
        }
        if (this.currentRecipe[this.currentSlot] != null && new TieredCentrifugeRecipe(this.currentRecipe[this.currentSlot]).matches((Container)new RecipeWrapper(inputHandler), this.f_58857_, this.currentSlot)) {
            return this.currentRecipe[this.currentSlot];
        }
        this.currentRecipe[this.currentSlot] = BeeHelper.getCentrifugeRecipe((Level)this.f_58857_, (IItemHandlerModifiable)inputHandler);
        Map allRecipes = this.f_58857_.m_7465_().m_44054_((RecipeType)ModRecipeTypes.CENTRIFUGE_TYPE.get());
        RecipeWrapper inv = new RecipeWrapper(inputHandler);
        for (Map.Entry entry : allRecipes.entrySet()) {
            CentrifugeRecipe recipe = (CentrifugeRecipe)entry.getValue();
            if (!new TieredCentrifugeRecipe(recipe).matches((Container)inv, this.f_58857_, this.currentSlot)) continue;
            this.currentRecipe[this.currentSlot] = recipe;
            break;
        }
        return this.currentRecipe[this.currentSlot];
    }

    protected boolean canProcessRecipe(@Nullable CentrifugeRecipe recipe, IItemHandlerModifiable invHandler) {
        if (recipe != null) {
            ArrayList outputList = Lists.newArrayList();
            recipe.getRecipeOutputs().forEach((stack, value) -> {
                ItemStack item = new ItemStack((ItemLike)stack.m_41720_(), value.get(1).m_7047_());
                outputList.add(item);
            });
            Pair fluidOutput = recipe.getFluidOutputs();
            boolean fluidFlag = true;
            if (fluidOutput != null) {
                fluidFlag = this.fluidInventory.map(h -> h.getFluidInTank(0).isEmpty() || h.getFluidInTank(0).getFluid().equals(fluidOutput.getFirst())).orElse(false);
            }
            return fluidFlag && ((InventoryHandlerHelper.ItemHandler)invHandler).canFitStacks(outputList);
        }
        return false;
    }

    protected void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler, RandomSource random) {
        this.completeRecipeProcessing(recipe, invHandler, random, true);
    }

    protected void completeRecipeProcessing(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler, RandomSource random, boolean stripWax) {
        ItemStack input = invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]).m_41777_();
        if (input.m_204117_(ModTags.Forge.COMBS) && !recipe.ingredient.test(input)) {
            ItemStack singleComb;
            if (input.m_41720_() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), 4);
                singleComb.m_41751_(input.m_41783_());
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput((Level)this.f_58857_, (Item)input.m_41720_());
            }
            invHandler.setStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot], singleComb);
            for (int i = 0; i < 4; ++i) {
                this.completeRecipeProcessing2(recipe, invHandler, random, stripWax);
            }
            input.m_41774_(1);
            invHandler.setStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot], input);
        } else {
            this.completeRecipeProcessing2(recipe, invHandler, random, stripWax);
        }
    }

    protected void completeRecipeProcessing2(CentrifugeRecipe recipe, IItemHandlerModifiable invHandler, RandomSource random, boolean stripWax) {
        recipe.getRecipeOutputs().forEach((itemStack, recipeValues) -> {
            if (!(stripWax && itemStack.m_204117_(ModTags.Forge.WAX) || random.m_188503_(100) > recipeValues.get(2).m_7047_())) {
                int count = Mth.m_216271_((RandomSource)random, (int)Mth.m_14143_((float)recipeValues.get(0).m_7047_()), (int)Mth.m_14143_((float)recipeValues.get(1).m_7047_()));
                ItemStack output = itemStack.m_41777_();
                output.m_41764_(count *= this.tier.getOutputMultiplier());
                ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(output);
            }
        });
        invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]).m_41774_(1);
        Pair fluidOutput = recipe.getFluidOutputs();
        if (fluidOutput != null) {
            this.fluidInventory.ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)fluidOutput.getFirst(), ((Integer)fluidOutput.getSecond()).intValue()), IFluidHandler.FluidAction.EXECUTE));
        }
    }

    private void completeGeneProcessing(IItemHandlerModifiable invHandler, RandomSource random) {
        ItemStack geneBottle = invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]);
        CompoundTag entityData = GeneBottle.getGenes((ItemStack)geneBottle);
        if (entityData == null) {
            return;
        }
        double chance = (Double)ProductiveBeesConfig.BEE_ATTRIBUTES.geneExtractChance.get();
        for (String attributeName : BeeAttributes.attributeList()) {
            if (!(random.m_188500_() <= chance)) continue;
            int value = entityData.m_128451_("bee_" + attributeName);
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack((BeeAttribute)BeeAttributes.getAttributeByName((String)attributeName), (int)value));
        }
        if (random.m_188500_() <= chance) {
            int typePurity = (Integer)ProductiveBeesConfig.BEE_ATTRIBUTES.typeGenePurity.get();
            ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(Gene.getStack((String)entityData.m_128461_("type"), (int)(random.m_188503_(Math.max(0, typePurity - 5)) + 10)));
        }
        invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]).m_41774_(1);
    }

    private void completeTreatProcessing(IItemHandlerModifiable invHandler) {
        ItemStack honeyTreat = invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]);
        ListTag genes = HoneyTreat.getGenes((ItemStack)honeyTreat);
        if (!genes.isEmpty()) {
            for (Tag inbt : genes) {
                ItemStack insertedGene = ItemStack.m_41712_((CompoundTag)((CompoundTag)inbt));
                if (((CompoundTag)inbt).m_128441_("purity")) {
                    int purity = ((CompoundTag)inbt).m_128451_("purity");
                    Gene.setPurity((ItemStack)insertedGene, (int)purity);
                }
                ((InventoryHandlerHelper.ItemHandler)invHandler).addOutput(insertedGene);
            }
        }
        invHandler.getStackInSlot(InventoryHandlerHelper.INPUT_SLOT[this.currentSlot]).m_41774_(1);
    }

    public void loadPacketNBT(CompoundTag tag) {
        super.loadPacketNBT(tag);
        this.recipeProgress = tag.m_128465_("RecipeProgress");
        Fluid fluid = this.fluidInventory.map(fluidHandler -> fluidHandler.getFluidInTank(0).getFluid()).orElse(Fluids.f_76191_);
        this.fluidId = BuiltInRegistries.f_257020_.m_7447_((Object)fluid);
        this.inventoryHandler.ifPresent(invHandler -> {
            for (int i = 0; i < InventoryHandlerHelper.OUTPUT_SLOTS.length; ++i) {
                invHandler.setStackInSlot(InventoryHandlerHelper.OUTPUT_SLOTS[i], new ItemStack((ItemLike)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_("SlotItem" + i)))).m_5456_(), tag.m_128451_("SlotItemAmount" + i)));
            }
        });
    }

    public void savePacketNBT(CompoundTag tag) {
        super.savePacketNBT(tag);
        tag.m_128385_("RecipeProgress", this.recipeProgress);
        int[] slotItemAmount = new int[InventoryHandlerHelper.OUTPUT_SLOTS.length];
        String[] slotItem = new String[InventoryHandlerHelper.OUTPUT_SLOTS.length];
        this.inventoryHandler.ifPresent(invHandler -> {
            for (int i = 0; i < slotItemAmount.length; ++i) {
                slotItemAmount[i] = invHandler.getStackInSlot(InventoryHandlerHelper.OUTPUT_SLOTS[i]).m_41613_();
                slotItem[i] = ForgeRegistries.ITEMS.getKey((Object)invHandler.getStackInSlot(InventoryHandlerHelper.OUTPUT_SLOTS[i]).m_41720_()).toString();
            }
        });
        for (int i = 0; i < slotItemAmount.length; ++i) {
            tag.m_128405_("SlotItemAmount" + i, slotItemAmount[i]);
            tag.m_128359_("SlotItem" + i, slotItem[i]);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidInventory.cast();
        }
        if (this.tier != CentrifugeTiers.CREATIVE && cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public Component m_7755_() {
        switch (this.tier) {
            case HIGH_END: {
                return Component.m_237115_((String)((Block)ModBlocks.HIGH_END_CENTRIFUGE.get()).m_7705_());
            }
            case NUCLEAR: {
                return Component.m_237115_((String)((Block)ModBlocks.NUCLEAR_CENTRIFUGE.get()).m_7705_());
            }
            case COSMIC: {
                return Component.m_237115_((String)((Block)ModBlocks.COSMIC_CENTRIFUGE.get()).m_7705_());
            }
            case CREATIVE: {
                return Component.m_237115_((String)((Block)ModBlocks.CREATIVE_CENTRIFUGE.get()).m_7705_());
            }
        }
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        MenuType menuType = null;
        switch (this.tier) {
            case HIGH_END: {
                menuType = (MenuType)ModMenuTypes.HIGH_END_CENTRIFUGE.get();
                break;
            }
            case NUCLEAR: {
                menuType = (MenuType)ModMenuTypes.NUCLEAR_CENTRIFUGE.get();
                break;
            }
            case COSMIC: {
                menuType = (MenuType)ModMenuTypes.COSMIC_CENTRIFUGE.get();
                break;
            }
            case CREATIVE: {
                menuType = (MenuType)ModMenuTypes.CREATIVE_CENTRIFUGE.get();
            }
        }
        return new TieredCentrifugeContainer(menuType, windowId, playerInventory, this);
    }
}

