/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.centrifugetiersreproduced.blocks;

import com.ultramega.centrifugetiersreproduced.CentrifugeTiers;
import com.ultramega.centrifugetiersreproduced.blockentity.TieredCentrifugeBlockEntity;
import com.ultramega.centrifugetiersreproduced.registry.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class TieredCentrifugeBlock
extends Centrifuge {
    private final CentrifugeTiers tier;

    public TieredCentrifugeBlock(CentrifugeTiers tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            BlockEntity tileEntity;
            boolean itemUsed;
            ItemStack heldItem = player.m_21120_(hand);
            boolean bl = itemUsed = heldItem.m_41720_().equals(Items.f_42446_) && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, null);
            if (!itemUsed && (tileEntity = world.m_7702_(pos)) instanceof TieredCentrifugeBlockEntity) {
                TieredCentrifugeBlockEntity blockEntity = (TieredCentrifugeBlockEntity)tileEntity;
                this.openGui((ServerPlayer)player, blockEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void openGui(ServerPlayer player, TieredCentrifugeBlockEntity tileEntity) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)tileEntity, packetBuffer -> packetBuffer.m_130064_(tileEntity.m_58899_()));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : TieredCentrifugeBlock.m_152132_(blockEntityType, (BlockEntityType)this.getBlockEntity(), (level1, pos1, state1, blockEntity1) -> TieredCentrifugeBlockEntity.tick(level1, pos1, state1, (TieredCentrifugeBlockEntity)blockEntity1));
    }

    public void m_5871_(@NotNull ItemStack stack, @Nullable BlockGetter getter, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        super.m_5871_(stack, getter, components, flag);
        if (Screen.m_96638_()) {
            if (this.tier == CentrifugeTiers.CREATIVE) {
                components.add((Component)Component.m_237115_((String)"tooltip.centrifugetiersreproduced.creative_centrifuge.needsNoEnergy").m_130940_(ChatFormatting.YELLOW));
                components.add((Component)Component.m_237115_((String)"tooltip.centrifugetiersreproduced.creative_centrifuge.oneTickPerComb").m_130940_(ChatFormatting.AQUA));
                components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.outputMultiplier", (Object[])new Object[]{this.tier.getOutputMultiplier()}).m_130940_(ChatFormatting.AQUA));
                components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.inputSlots", (Object[])new Object[]{this.tier.getInputSlotAmount()}).m_130940_(ChatFormatting.AQUA));
            } else {
                components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.fasterThanHeated", (Object[])new Object[]{this.tier.getSpeed()}).m_130940_(ChatFormatting.AQUA));
                components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.outputMultiplier", (Object[])new Object[]{this.tier.getOutputMultiplier()}).m_130940_(ChatFormatting.AQUA));
                components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.inputSlots", (Object[])new Object[]{this.tier.getInputSlotAmount()}).m_130940_(ChatFormatting.AQUA));
                components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.energyCapacity", (Object[])new Object[]{String.format("%,d", this.tier.getEnergyCapacity())}).m_130940_(ChatFormatting.AQUA));
            }
            components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.fluidCapacity", (Object[])new Object[]{String.format("%,d", this.tier.getFluidCapacity())}).m_130940_(ChatFormatting.AQUA));
            components.add((Component)Component.m_237110_((String)"tooltip.centrifugetiersreproduced.centrifuge.maxStackSize", (Object[])new Object[]{String.format("%,d", this.tier.getItemMaxStackSize())}).m_130940_(ChatFormatting.AQUA));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.centrifugetiersreproduced.centrifuge.pressShiftForMore").m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TieredCentrifugeBlockEntity(this.getBlockEntity(), pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    private BlockEntityType getBlockEntity() {
        switch (this.tier) {
            case HIGH_END: {
                return (BlockEntityType)ModBlockEntityTypes.HIGH_END_CENTRIFUGE.get();
            }
            case NUCLEAR: {
                return (BlockEntityType)ModBlockEntityTypes.NUCLEAR_CENTRIFUGE.get();
            }
            case COSMIC: {
                return (BlockEntityType)ModBlockEntityTypes.COSMIC_CENTRIFUGE.get();
            }
            case CREATIVE: {
                return (BlockEntityType)ModBlockEntityTypes.CREATIVE_CENTRIFUGE.get();
            }
        }
        return null;
    }
}

