/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.centrifugetiersreproduced.container;

import com.ultramega.centrifugetiersreproduced.CentrifugeTiers;
import com.ultramega.centrifugetiersreproduced.blockentity.InventoryHandlerHelper;
import com.ultramega.centrifugetiersreproduced.blockentity.TieredCentrifugeBlockEntity;
import com.ultramega.centrifugetiersreproduced.blocks.TieredCentrifugeBlock;
import com.ultramega.centrifugetiersreproduced.container.AbstractContainer;
import com.ultramega.centrifugetiersreproduced.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class TieredCentrifugeContainer
extends AbstractContainer {
    public final TieredCentrifugeBlockEntity blockEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public TieredCentrifugeContainer(MenuType menuType, int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(menuType, windowId, playerInventory, TieredCentrifugeContainer.getTileEntity(playerInventory, data));
    }

    public TieredCentrifugeContainer(MenuType menuType, int windowId, Inventory playerInventory, final TieredCentrifugeBlockEntity blockEntity) {
        super(menuType, windowId);
        this.blockEntity = blockEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.m_38884_(new ContainerData(){

            public int m_6413_(int i) {
                return i == 0 ? blockEntity.fluidId : blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> fluidHandler.getFluidInTank(0).getAmount()).orElse(0);
            }

            public void m_8050_(int i, int value) {
                switch (i) {
                    case 0: {
                        blockEntity.fluidId = value;
                    }
                    case 1: {
                        blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandler -> {
                            FluidStack fluid = fluidHandler.getFluidInTank(0);
                            if (fluid.isEmpty()) {
                                fluidHandler.fill(new FluidStack((Fluid)BuiltInRegistries.f_257020_.m_7942_(blockEntity2.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            } else {
                                fluid.setAmount(value);
                            }
                        });
                    }
                }
            }

            public int m_6499_() {
                return 2;
            }
        });
        int i = 0;
        while (i < blockEntity.recipeProgress.length) {
            final int finalI = i++;
            this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return blockEntity.recipeProgress[finalI];
                }

                public void m_6422_(int value) {
                    blockEntity.recipeProgress[finalI] = value;
                }
            });
        }
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), InventoryHandlerHelper.INPUT_SLOT[0], 13, 17));
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), InventoryHandlerHelper.INPUT_SLOT[1], 13, 53));
            if (blockEntity.tier == CentrifugeTiers.NUCLEAR || blockEntity.tier == CentrifugeTiers.COSMIC || blockEntity.tier == CentrifugeTiers.CREATIVE) {
                this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), InventoryHandlerHelper.INPUT_SLOT[2], 13, 35));
            }
            if (blockEntity.tier == CentrifugeTiers.COSMIC || blockEntity.tier == CentrifugeTiers.CREATIVE) {
                this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), InventoryHandlerHelper.INPUT_SLOT[3], 13, 71));
            }
            int vertAmount = blockEntity.tier == CentrifugeTiers.COSMIC || blockEntity.tier == CentrifugeTiers.CREATIVE ? 4 : 3;
            int horAmount = blockEntity.tier == CentrifugeTiers.CREATIVE ? 4 : 3;
            this.addSlotBox((IItemHandler)inv, InventoryHandlerHelper.OUTPUT_SLOTS[0], 67, 17, horAmount, 18, vertAmount, 18);
        });
        if (blockEntity.tier != CentrifugeTiers.CREATIVE) {
            this.blockEntity.getUpgradeHandler().ifPresent(upgradeHandler -> this.addSlotBox((IItemHandler)upgradeHandler, 0, 165, 8, 1, 18, 4, 18));
        }
        int topRow = blockEntity.tier == CentrifugeTiers.COSMIC || blockEntity.tier == CentrifugeTiers.CREATIVE ? 102 : 84;
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, topRow);
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            }

            public void m_6422_(int value) {
                blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                    if (handler.getEnergyStored() > 0) {
                        handler.extractEnergy(handler.getEnergyStored(), false);
                    }
                    if (value > 0) {
                        handler.receiveEnergy(value, false);
                    }
                });
            }
        });
    }

    private static TieredCentrifugeBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof TieredCentrifugeBlockEntity) {
            TieredCentrifugeBlockEntity tile = (TieredCentrifugeBlockEntity)tileAtPos;
            return tile;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof TieredCentrifugeBlock && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    protected BlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

