/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.centrifugetiersreproduced.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

class FluidContainerUtil {
    FluidContainerUtil() {
    }

    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    private static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void setColors(int color) {
        RenderSystem.setShaderColor((float)FluidContainerUtil.getRed(color), (float)FluidContainerUtil.getGreen(color), (float)FluidContainerUtil.getBlue(color), (float)FluidContainerUtil.getAlpha(color));
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
    }

    public static void renderFluidTank(GuiGraphics matrices, AbstractContainerScreen<?> screen, FluidStack stack, int capacity, int x, int y, int width, int height, int depth) {
        FluidContainerUtil.renderFluidTank(matrices, screen, stack, stack.getAmount(), capacity, x, y, width, height, depth);
    }

    public static void renderFluidTank(GuiGraphics matrices, AbstractContainerScreen<?> screen, FluidStack stack, int amount, int capacity, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty() && capacity > 0) {
            int maxY = y + height;
            int fluidHeight = Math.min(height * amount / capacity, height);
            FluidContainerUtil.renderTiledFluid(matrices, screen, stack, x, maxY - fluidHeight, width, fluidHeight, depth);
        }
    }

    public static void renderTiledFluid(GuiGraphics matrices, AbstractContainerScreen<?> screen, FluidStack stack, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty()) {
            IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
            TextureAtlasSprite fluidSprite = (TextureAtlasSprite)screen.getMinecraft().m_91258_(InventoryMenu.f_39692_).apply(attributes.getStillTexture());
            FluidContainerUtil.setColors(attributes.getTintColor());
            FluidContainerUtil.renderTiledTextureAtlas(matrices, screen, fluidSprite, x, y, width, height, depth, false);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTiledTextureAtlas(GuiGraphics matrices, AbstractContainerScreen<?> screen, TextureAtlasSprite sprite, int x, int y, int width, int height, int depth, boolean upsideDown) {
        FluidContainerUtil.bindTexture(sprite.m_247685_());
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        int spriteHeight = sprite.m_245424_().m_245330_();
        int spriteWidth = sprite.m_245424_().m_246492_();
        int startX = x + screen.getGuiLeft();
        int startY = y + screen.getGuiTop();
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.m_118393_((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            int x2 = startX;
            int widthLeft = width;
            Matrix4f matrix = matrices.m_280168_().m_85850_().m_252922_();
            do {
                int renderWidth = Math.min(spriteWidth, widthLeft);
                widthLeft -= renderWidth;
                float u2 = sprite.m_118367_((double)(16.0f * (float)renderWidth / (float)spriteWidth));
                if (upsideDown) {
                    FluidContainerUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v2, v1);
                } else {
                    FluidContainerUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                }
                x2 += renderWidth;
            } while (widthLeft > 0);
            startY += renderHeight;
        } while (height > 0);
        RenderSystem.enableDepthTest();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    private static void buildSquare(Matrix4f matrix, BufferBuilder builder, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        builder.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
    }
}

