/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.StandardBlocks;

public class EdChair {
    private static boolean sitting_enabled = true;
    private static double sitting_probability = 0.1;
    private static double standup_probability = 0.01;

    public static void on_config(boolean without_sitting, boolean without_mob_sitting, double sitting_probability_percent, double standup_probability_percent) {
        sitting_enabled = !without_sitting;
        sitting_probability = without_sitting || without_mob_sitting ? 0.0 : Mth.m_14008_((double)(sitting_probability_percent / 100.0), (double)0.0, (double)0.9);
        standup_probability = without_sitting || without_mob_sitting ? 1.0 : Mth.m_14008_((double)(standup_probability_percent / 100.0), (double)1.0E-6, (double)0.01);
        ModConfig.log("Config chairs: sit:" + sitting_enabled + ", mob-sit: " + sitting_probability * 100.0 + "%, standup: " + standup_probability + "%.");
    }

    public static class EntityChair
    extends Entity {
        public static final double x_offset = 0.5;
        public static final double y_offset = 0.4;
        public static final double z_offset = 0.5;
        private int t_sit = 0;
        public BlockPos chair_pos = new BlockPos(0, 0, 0);

        public EntityChair(EntityType<? extends Entity> entityType, Level world) {
            super(entityType, world);
            this.f_19850_ = true;
            this.m_20256_(Vec3.f_82478_);
            this.canUpdate(true);
            this.f_19794_ = true;
        }

        public EntityChair(Level world) {
            this(ModContent.getEntityType("et_chair"), world);
        }

        public static EntityChair customClientFactory(PlayMessages.SpawnEntity spkt, Level world) {
            return new EntityChair(world);
        }

        public Packet<ClientGamePacketListener> m_5654_() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        public static boolean accepts_mob(LivingEntity entity) {
            if (!(entity instanceof Monster)) {
                return false;
            }
            if ((double)entity.m_6095_().m_20680_().f_20378_ > 2.5 || (double)entity.m_6095_().m_20680_().f_20378_ > 2.0) {
                return false;
            }
            if (entity instanceof Zombie) {
                return true;
            }
            if (entity instanceof ZombieVillager) {
                return true;
            }
            if (entity instanceof ZombifiedPiglin) {
                return true;
            }
            if (entity instanceof Piglin) {
                return true;
            }
            if (entity instanceof Husk) {
                return true;
            }
            if (entity instanceof Stray) {
                return true;
            }
            if (entity instanceof Skeleton) {
                return true;
            }
            return entity instanceof WitherSkeleton;
        }

        public static void sit(Level world, LivingEntity sitter, BlockPos pos) {
            if (!sitting_enabled) {
                return;
            }
            if (world == null || world.f_46443_ || sitter == null || pos == null) {
                return;
            }
            if (!(sitter instanceof Player) && !EntityChair.accepts_mob(sitter)) {
                return;
            }
            if (!world.m_45976_(EntityChair.class, new AABB(pos)).isEmpty()) {
                return;
            }
            if (sitter.m_20160_() || !sitter.m_6084_() || sitter.m_20159_()) {
                return;
            }
            if (!world.m_46859_(pos.m_7494_()) || !world.m_46859_(pos.m_6630_(2))) {
                return;
            }
            boolean on_top_of_block_position = true;
            boolean use_next_negative_y_position = false;
            EntityChair chair = new EntityChair(world);
            BlockPos chair_pos = chair.m_20183_();
            chair.chair_pos = pos;
            chair.t_sit = 5;
            chair.f_19854_ = chair_pos.m_123341_();
            chair.f_19855_ = chair_pos.m_123342_();
            chair.f_19856_ = chair_pos.m_123343_();
            chair.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5);
            world.m_7967_((Entity)chair);
            sitter.m_7998_((Entity)chair, true);
        }

        protected void m_8097_() {
        }

        protected void m_7378_(CompoundTag compound) {
        }

        protected void m_7380_(CompoundTag compound) {
        }

        public boolean m_6094_() {
            return false;
        }

        public double m_6048_() {
            return 0.0;
        }

        public void m_8119_() {
            Entity sitter;
            if (this.m_9236_().f_46443_) {
                return;
            }
            super.m_8119_();
            if (--this.t_sit > 0) {
                return;
            }
            Entity entity = sitter = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
            if (sitter == null || !sitter.m_6084_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            boolean abort = !sitting_enabled;
            BlockState state = this.m_9236_().m_8055_(this.chair_pos);
            if (state == null || !(state.m_60734_() instanceof ChairBlock)) {
                abort = true;
            }
            if (!this.m_9236_().m_46859_(this.chair_pos.m_7494_())) {
                abort = true;
            }
            if (!(sitter instanceof Player) && Math.random() < standup_probability) {
                abort = true;
            }
            if (abort) {
                for (Entity e : this.m_20197_()) {
                    if (!e.m_6084_()) continue;
                    e.m_8127_();
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public static class ChairBlock
    extends StandardBlocks.HorizontalWaterLoggable {
        public ChairBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABBs) {
            super(config, builder.m_60977_(), unrotatedAABBs);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (!sitting_enabled) {
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            EntityChair.sit(world, (LivingEntity)player, pos);
            return InteractionResult.CONSUME;
        }

        public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
            if (sitting_enabled && Math.random() < sitting_probability && entity instanceof Mob) {
                EntityChair.sit(world, (LivingEntity)entity, pos);
            }
        }

        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            if (!sitting_enabled || sitting_probability < 1.0E-6) {
                return;
            }
            List entities = world.m_6443_(Mob.class, new AABB(pos).m_82377_(2.0, 1.0, 2.0).m_82363_(0.0, 1.0, 0.0), e -> true);
            if (entities.isEmpty()) {
                return;
            }
            int index = rnd.m_188503_(entities.size());
            if (index < 0 || index >= entities.size()) {
                return;
            }
            EntityChair.sit((Level)world, (LivingEntity)entities.get(index), pos);
        }
    }
}

