/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import wile.engineersdecor.libmc.Inventories;

public class Crafting {
    public static Optional<CraftingRecipe> getCraftingRecipe(Level world, ResourceLocation recipe_id) {
        Recipe recipe = world.m_7465_().m_44043_(recipe_id).orElse(null);
        return recipe instanceof CraftingRecipe ? Optional.of((CraftingRecipe)recipe) : Optional.empty();
    }

    public static List<CraftingRecipe> get3x3CraftingRecipes(Level world, Container crafting_grid_slots) {
        return CraftingGrid.instance3x3.getRecipes(world, crafting_grid_slots);
    }

    public static Optional<CraftingRecipe> get3x3CraftingRecipe(Level world, Container crafting_grid_slots) {
        return Crafting.get3x3CraftingRecipes(world, crafting_grid_slots).stream().findFirst();
    }

    public static ItemStack get3x3CraftingResult(Level world, Container grid, CraftingRecipe recipe) {
        return CraftingGrid.instance3x3.getCraftingResult(world, grid, recipe);
    }

    public static List<ItemStack> get3x3RemainingItems(Level world, Container grid, CraftingRecipe recipe) {
        return CraftingGrid.instance3x3.getRemainingItems(world, grid, recipe);
    }

    public static List<ItemStack> get3x3Placement(Level world, CraftingRecipe recipe, Container item_inventory, @Nullable Container crafting_grid) {
        int i;
        int width = 3;
        int height = 3;
        if (!recipe.m_8004_(3, 3)) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> used = new ArrayList<ItemStack>();
        for (int i2 = 9; i2 > 0; --i2) {
            used.add(ItemStack.f_41583_);
        }
        Container check_inventory = Inventories.copyOf(item_inventory);
        Inventories.InventoryRange source = new Inventories.InventoryRange(check_inventory);
        NonNullList ingredients = recipe.m_7527_();
        ArrayList<ItemStack> preferred = new ArrayList<ItemStack>(9);
        if (crafting_grid != null) {
            for (i = 0; i < crafting_grid.m_6643_(); ++i) {
                ItemStack stack = crafting_grid.m_8020_(i);
                if (stack.m_41619_()) continue;
                stack = stack.m_41777_();
                stack.m_41764_(1);
                if (source.extract(stack).m_41619_()) continue;
                preferred.add(stack);
            }
        }
        for (i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient == Ingredient.f_43901_) continue;
            ItemStack stack = preferred.stream().filter(ingredient).findFirst().orElse(ItemStack.f_41583_);
            if (!stack.m_41619_()) {
                preferred.remove(stack);
            } else {
                stack = source.stream().filter((Predicate<ItemStack>)ingredient).findFirst().orElse(ItemStack.f_41583_);
                if (stack.m_41619_()) {
                    return Collections.emptyList();
                }
                stack = stack.m_41777_();
                stack.m_41764_(1);
                if (source.extract(stack).m_41619_()) {
                    return Collections.emptyList();
                }
            }
            used.set(i, stack);
        }
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            NonNullList placement = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
            for (int row = 0; row < shaped.getRecipeHeight(); ++row) {
                for (int col = 0; col < shaped.getRecipeWidth(); ++col) {
                    placement.set(3 * row + col, (ItemStack)used.get(row * shaped.getRecipeWidth() + col));
                }
            }
            return placement;
        }
        return used;
    }

    public static <T extends Recipe<?>> Optional<AbstractCookingRecipe> getFurnaceRecipe(RecipeType<T> recipe_type, Level world, ItemStack input_stack) {
        if (input_stack.m_41619_()) {
            return Optional.empty();
        }
        if (recipe_type == RecipeType.f_44108_) {
            SimpleContainer inventory = new SimpleContainer(3);
            inventory.m_6836_(0, input_stack);
            SmeltingRecipe recipe = world.m_7465_().m_44015_(RecipeType.f_44108_, (Container)inventory, world).orElse(null);
            return recipe == null ? Optional.empty() : Optional.of(recipe);
        }
        if (recipe_type == RecipeType.f_44109_) {
            SimpleContainer inventory = new SimpleContainer(3);
            inventory.m_6836_(0, input_stack);
            BlastingRecipe recipe = world.m_7465_().m_44015_(RecipeType.f_44109_, (Container)inventory, world).orElse(null);
            return recipe == null ? Optional.empty() : Optional.of(recipe);
        }
        if (recipe_type == RecipeType.f_44110_) {
            SimpleContainer inventory = new SimpleContainer(3);
            inventory.m_6836_(0, input_stack);
            SmokingRecipe recipe = world.m_7465_().m_44015_(RecipeType.f_44110_, (Container)inventory, world).orElse(null);
            return recipe == null ? Optional.empty() : Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static <T extends Recipe<?>> int getSmeltingTimeNeeded(RecipeType<T> recipe_type, Level world, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        int t = Crafting.getFurnaceRecipe(recipe_type, world, stack).map(AbstractCookingRecipe::m_43753_).orElse(0);
        return t <= 0 ? 200 : t;
    }

    public static int getFuelBurntime(Level world, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        int t = ForgeHooks.getBurnTime((ItemStack)stack, null);
        return Math.max(t, 0);
    }

    public static boolean isFuel(Level world, ItemStack stack) {
        return Crafting.getFuelBurntime(world, stack) > 0 || stack.m_41720_() == Items.f_42448_;
    }

    public static Tuple<Integer, ItemStack> consumeFuel(Level world, ItemStack stack) {
        if (stack.m_41619_()) {
            return new Tuple((Object)0, (Object)stack);
        }
        int burnime = Crafting.getFuelBurntime(world, stack);
        if (stack.m_41720_() == Items.f_42448_) {
            if (burnime <= 0) {
                burnime = 20000;
            }
            return new Tuple((Object)burnime, (Object)new ItemStack((ItemLike)Items.f_42446_));
        }
        if (burnime <= 0) {
            return new Tuple((Object)0, (Object)stack);
        }
        ItemStack left_over = stack.m_41777_();
        left_over.m_41774_(1);
        return new Tuple((Object)burnime, (Object)left_over);
    }

    public static boolean isBrewingFuel(Level world, ItemStack stack) {
        return stack.m_41720_() == Items.f_42593_ || stack.m_41720_() == Items.f_42585_;
    }

    public static boolean isBrewingIngredient(Level world, ItemStack stack) {
        return BrewingRecipeRegistry.isValidIngredient((ItemStack)stack);
    }

    public static boolean isBrewingInput(Level world, ItemStack stack) {
        return BrewingRecipeRegistry.isValidInput((ItemStack)stack);
    }

    public static int getBrewingFuelBurntime(Level world, ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == Items.f_42593_) {
            return 8000;
        }
        if (stack.m_41720_() == Items.f_42585_) {
            return 16000;
        }
        return 0;
    }

    public static Tuple<Integer, ItemStack> consumeBrewingFuel(Level world, ItemStack stack) {
        int burntime = Crafting.getBrewingFuelBurntime(world, stack);
        if (burntime <= 0) {
            return new Tuple((Object)0, (Object)stack.m_41777_());
        }
        stack = stack.m_41777_();
        stack.m_41774_(1);
        return new Tuple((Object)burntime, (Object)(stack.m_41619_() ? ItemStack.f_41583_ : stack));
    }

    public static double getCompostingChance(ItemStack stack) {
        return ComposterBlock.f_51914_.getOrDefault((Object)stack.m_41720_(), 0.0f);
    }

    public static Map<Enchantment, Integer> getEnchantmentsOnItem(Level world, ItemStack stack) {
        return stack.m_41619_() || stack.m_41783_() == null ? Collections.emptyMap() : EnchantmentHelper.m_44831_((ItemStack)stack);
    }

    public static ItemStack getEnchantmentBook(Level world, Enchantment enchantment, int level) {
        return !enchantment.isAllowedOnBooks() || level <= 0 ? ItemStack.f_41583_ : EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
    }

    public static int getEnchantmentRepairCost(Level world, Map<Enchantment, Integer> enchantments) {
        int repair_cost = 0;
        for (Map.Entry<Enchantment, Integer> e : enchantments.entrySet()) {
            repair_cost = repair_cost * 2 + 1;
        }
        return repair_cost;
    }

    public static boolean addEnchantmentOnItem(Level world, ItemStack stack, Enchantment enchantment, int level) {
        if (stack.m_41619_() || level <= 0 || !stack.m_41792_() || level >= enchantment.m_6586_()) {
            return false;
        }
        Map<Enchantment, Integer> on_item = Crafting.getEnchantmentsOnItem(world, stack);
        if (on_item.keySet().stream().anyMatch(ench -> ench.m_44695_(enchantment))) {
            return false;
        }
        ItemStack book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
        if (!(stack.isBookEnchantable(book) && enchantment.isAllowedOnBooks() || stack.canApplyAtEnchantingTable(enchantment) || enchantment.m_6081_(stack))) {
            return false;
        }
        int existing_level = on_item.getOrDefault(enchantment, 0);
        if (existing_level > 0) {
            level = Mth.m_14045_((int)(level + existing_level), (int)1, (int)enchantment.m_6586_());
        }
        on_item.put(enchantment, level);
        EnchantmentHelper.m_44865_(on_item, (ItemStack)stack);
        stack.m_41742_(Crafting.getEnchantmentRepairCost(world, on_item));
        return true;
    }

    public static Map<Enchantment, Integer> removeEnchantmentsOnItem(Level world, ItemStack stack, BiPredicate<Enchantment, Integer> filter) {
        if (stack.m_41619_()) {
            return Collections.emptyMap();
        }
        Map<Enchantment, Integer> on_item = Crafting.getEnchantmentsOnItem(world, stack);
        HashMap<Enchantment, Integer> removed = new HashMap<Enchantment, Integer>();
        for (Map.Entry<Enchantment, Integer> entry : on_item.entrySet()) {
            if (!filter.test(entry.getKey(), entry.getValue())) continue;
            removed.put(entry.getKey(), entry.getValue());
        }
        for (Enchantment enchantment : removed.keySet()) {
            on_item.remove(enchantment);
        }
        EnchantmentHelper.m_44865_(on_item, (ItemStack)stack);
        stack.m_41742_(Crafting.getEnchantmentRepairCost(world, on_item));
        return removed;
    }

    public static final class CraftingGrid
    implements CraftingContainer {
        protected static final CraftingGrid instance3x3 = new CraftingGrid(3, 3);

        protected CraftingGrid(int width, int height) {
        }

        protected void fill(Container grid) {
            for (int i = 0; i < this.m_6643_(); ++i) {
                this.m_6836_(i, i >= grid.m_6643_() ? ItemStack.f_41583_ : grid.m_8020_(i));
            }
        }

        public List<CraftingRecipe> getRecipes(Level world, Container grid) {
            this.fill(grid);
            return world.m_7465_().m_44056_(RecipeType.f_44107_, (Container)this, world);
        }

        public List<ItemStack> getRemainingItems(Level world, Container grid, CraftingRecipe recipe) {
            this.fill(grid);
            return recipe.m_7457_((Container)this);
        }

        public ItemStack getCraftingResult(Level world, Container grid, CraftingRecipe recipe) {
            this.fill(grid);
            return recipe.m_5874_((Container)this, (RegistryAccess)RegistryAccess.f_243945_);
        }

        public int m_39347_() {
            return 0;
        }

        public int m_39346_() {
            return 0;
        }

        public List<ItemStack> m_280657_() {
            return null;
        }

        public int m_6643_() {
            return 0;
        }

        public boolean m_7983_() {
            return false;
        }

        public ItemStack m_8020_(int i) {
            return null;
        }

        public ItemStack m_7407_(int i, int i1) {
            return null;
        }

        public ItemStack m_8016_(int i) {
            return null;
        }

        public void m_6836_(int i, ItemStack itemStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return false;
        }

        public void m_6211_() {
        }

        public void m_5809_(StackedContents stackedContents) {
        }
    }

    public static final class BrewingOutput {
        public static final int DEFAULT_BREWING_TIME = 400;
        public static final BrewingOutput EMPTY = new BrewingOutput(ItemStack.f_41583_, (Container)new SimpleContainer(1), (Container)new SimpleContainer(1), 0, 0, 400);
        public final ItemStack item;
        public final Container potionInventory;
        public final Container ingredientInventory;
        public final int potionSlot;
        public final int ingredientSlot;
        public final int brewTime;

        public BrewingOutput(ItemStack output_potion, Container potion_inventory, Container ingredient_inventory, int potion_slot, int ingredient_slot, int time_needed) {
            this.item = output_potion;
            this.potionInventory = potion_inventory;
            this.ingredientInventory = ingredient_inventory;
            this.potionSlot = potion_slot;
            this.ingredientSlot = ingredient_slot;
            this.brewTime = time_needed;
        }

        public static BrewingOutput find(Level world, Container potion_inventory, Container ingredient_inventory) {
            for (int potion_slot = 0; potion_slot < potion_inventory.m_6643_(); ++potion_slot) {
                ItemStack pstack = potion_inventory.m_8020_(potion_slot);
                if (!Crafting.isBrewingInput(world, pstack)) continue;
                for (int ingredient_slot = 0; ingredient_slot < ingredient_inventory.m_6643_(); ++ingredient_slot) {
                    ItemStack result;
                    ItemStack istack = ingredient_inventory.m_8020_(ingredient_slot);
                    if (!Crafting.isBrewingIngredient(world, istack) || ingredient_slot == potion_slot || Crafting.isBrewingFuel(world, istack) || (result = BrewingRecipeRegistry.getOutput((ItemStack)pstack, (ItemStack)istack)).m_41619_()) continue;
                    return new BrewingOutput(result, potion_inventory, ingredient_inventory, potion_slot, ingredient_slot, 400);
                }
            }
            return EMPTY;
        }
    }
}

